Imports System.Web.Services
Imports System.Web.Services.Protocols
Imports System.Data.SqlClient
Imports System.Xml


<WebService(Namespace := "http://tempuri.org/")> _
Public Class LunchSpotSoapHeader
    Inherits System.Web.Services.WebService

#Region " Web Services Designer Generated Code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Web Services Designer.
        InitializeComponent()

        'Add your own initialization code after the InitializeComponent() call

    End Sub

    'Required by the Web Services Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Web Services Designer
    'It can be modified using the Web Services Designer.  
    'Do not modify it using the code editor.
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        components = New System.ComponentModel.Container()
    End Sub

    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        'CODEGEN: This procedure is required by the Web Services Designer
        'Do not modify it using the code editor.
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

#End Region
    Public mySoapHeaderData As LunchAuthHeader

    <WebMethod(), SoapHeader("mySoapHeaderData")> Public Function SelectRandom(ByVal MaxDistance As Integer) As String
        'validate the session
        If (ValidSession(mySoapHeaderData.SessionID) = True) Then
            Return SelectLunchLocation(MaxDistance)
        Else
            Throw LunchSpotSOAPException("Invalid session id")
        End If
    End Function

    '*****************************************************************************************
    ' NAME:         ValidSession
    ' DESCRIPTION:  Verifies that a row (session) exists in the DemoSessions table.  Returns 
    '               TRUE if SessionID exists in DemoSessions table and FALSE if it does not.
    '*****************************************************************************************
    Private Function ValidSession(ByVal SessionID As String) As Boolean
        Dim objConnection As SqlConnection = New SqlConnection(System.Configuration.ConfigurationSettings.AppSettings.Get("connectionString").ToString())
        Dim objSelectCommand As SqlCommand = New SqlCommand("SELECT * FROM DemoSessions WHERE SessionID = '" & SessionID & "'", objConnection)
        Dim bolReturnValue As Boolean

        objSelectCommand.Connection.Open()
        Dim objDataReader As SqlDataReader
        objDataReader = objSelectCommand.ExecuteReader()
        If (objDataReader.Read() = True) Then
            'Row exists, assume valid session
            bolReturnValue = True
        Else
            'Row does not exist, no valid session
            bolReturnValue = False
        End If
        objSelectCommand.Connection.Close()

        Return bolReturnValue
    End Function

    '*****************************************************************************************
    ' NAME:         SelectLunchLocation
    ' DESCRIPTION:  Loads the available lunch location from the lunch.xml file.  Then randomly
    '               select the lunch location for this call.
    '*****************************************************************************************
    Private Function SelectLunchLocation(ByVal MaxDistance As Integer) As String
        Dim Restaurants As ArrayList
        Dim IndexValue As Integer

        'load the available lunch locations
        Restaurants = LoadSpots(MaxDistance)

        'Get a random index value
        IndexValue = GetVeryRandom(Restaurants.Count)

        ' My algorithm is very simple, so it requires some cleanup
        If (IndexValue > (Restaurants.Count - 1)) Then
            IndexValue = Convert.ToInt32(Restaurants.Count - 1)
        ElseIf (IndexValue < 0) Then
            IndexValue = 0
        End If
        Return Restaurants(IndexValue)
    End Function

    Private Function GetVeryRandom(ByVal UpperBound As Double) As Byte
        Dim IndexValue As Byte = New Byte()
        Dim ByteValue As Byte = 255

        ' Use the random number generator in the RNG CSP
        ' Could also use System.Random

        Dim NewRandom As System.Security.Cryptography.RNGCryptoServiceProvider = New System.Security.Cryptography.RNGCryptoServiceProvider()

        Dim WeightValue As Double = ByteValue / UpperBound
        Dim ByteArray(1) As Byte

        ' Returns an array filled with random numbers.
        ' We pulled one number. Function will fill
        ' an array of size n with n random numbers
        NewRandom.GetBytes(ByteArray)

        Dim SegmentValue As Double = System.Math.Round(ByteArray(0) / WeightValue)

        IndexValue = Convert.ToByte(SegmentValue)

        If (IndexValue > (UpperBound - 1)) Then
            IndexValue = Convert.ToByte(UpperBound - 1)
        ElseIf (IndexValue < 0) Then
            IndexValue = 0
        End If
        Return IndexValue
    End Function

    Private Function LoadSpots(ByVal MaxDistance As Integer) As ArrayList
        ' XML file has a lunchspot element with four elements:

        ' name = the name of the lunch spot
        ' weight = the number of times you want the lunchspot to occur
        '		in the randomizer array. A weigthing of 10 means the lunchspot
        '		will have 10 times as many entries as a lunchspot with a weighting
        '		of 1, and, as such, be 10 times as likely to be selected
        ' pricetype = ranking of relative cost of restaurant (not implemented)
        ' distance = distance from office in blocks
        '
        ' ie. <lunchspot name="Robinson's" weight="8" pricetype="1" distance="4"/>
        Dim LunchSet As New DataSet()
        Dim dr As DataRow
        Dim WeightValue As Integer
        Dim RestaurantArray As New System.Collections.ArrayList()


        LunchSet.ReadXml(Context.Server.MapPath(".") & System.IO.Path.DirectorySeparatorChar & "lunch.xml")

        For Each dr In LunchSet.Tables(0).Rows
            '0 - name
            '1 - weight
            '2 - pricetype
            '3 - distance
            If Convert.ToInt16(dr(3).ToString()) <= MaxDistance Then

                WeightValue = Convert.ToInt16(dr(1).ToString())
                'Add the item to the array the weighted # of times
                Dim y As Integer
                For y = 1 To WeightValue
                    RestaurantArray.Add(dr(0).ToString())
                    y += 1
                Next
            End If
        Next
        'return the arraylist
        Return RestaurantArray
    End Function

    '*****************************************************************************************
    ' NAME:         LunchSpotSOAPException
    ' DESCRIPTION:  Returns a custom SOAP exception with the specified error message.
    '*****************************************************************************************
    Private Function LunchSpotSOAPException(ByVal Message As String) As SoapException
        'Raise SOAP exception, with description
        Dim doc As New System.Xml.XmlDocument()
        Dim node As System.Xml.XmlNode = doc.CreateNode(XmlNodeType.Element, _
            SoapException.DetailElementName.Name, SoapException.DetailElementName.Namespace)

        Dim details As System.Xml.XmlNode = doc.CreateNode(XmlNodeType.Element, _
            "HotelReservationFault", "http://tempuri.org/")

        details.InnerText = Message
        node.AppendChild(details)

        Return New SoapException("Fault occurred", SoapException.ClientFaultCode, Context.Request.Url.AbsoluteUri, node)
    End Function

End Class
